// @flow
import { createStore, applyMiddleware } from 'redux';
import thunk from 'redux-thunk';
import { createHashHistory } from 'history';
import { routerMiddleware } from 'connected-react-router';
import createRootReducer from './reducers';
import { subscribePersistedStore } from './persistedStore';

const history = createHashHistory();
const rootReducer = createRootReducer(history);
const router = routerMiddleware(history);
const enhancer = applyMiddleware(thunk, router);

function configureStore(initialState?) {
  const store = createStore(rootReducer, initialState, enhancer);
  subscribePersistedStore(store);
  return store;
}

export default { configureStore, history };
